/*------------------------------------------------------------------------------*
 * File Name:	GraphObjToolDlg.h												*
 * Creation: 	Sophy 3/9/2010													*
 * Purpose: OriginC Source H file												*
 * Copyright (c) OriginLab Corp.2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////

///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
#include <..\OriginLab\DialogEx.h>
#include <..\OriginLab\GridTableControl.h>

enum {
	MSG_CREATE,
	MSG_DESTROY,
	MSG_START_GADGET,	//attach, when ActiveLayer change etc
	MSG_UPDATE_DATA,	//update data, when OnMove etc
};

enum {
	TAB_INNER_POINTS = 0,
	TAB_OUTER_POINTS = 1,
};

#define	IDC_BTN_PREPERENCES	IDC_BUTTON1
#define	IDC_BTN_EDIT		IDC_BUTTON2
#define	IDC_OUTPUT_RESULT	IDC_BUTTON3
class	GadgetDlg : public ResizeDialog
{
public:
	GadgetDlg();
	~GadgetDlg();
	
	BOOL	Create(HWND hWndParent = NULL);
	virtual	BOOL	StartGadget(){ return FALSE; }
	virtual	BOOL	UpdateDlgData(){ return FALSE; }
	virtual	BOOL	UpdateSettings(){ return FALSE; }
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_DESTROY(OnDestroy)
	ON_HELPINFO(OnHelp)
	ON_OK(OnOK)
	ON_CANCEL(OnCancel)
	
	ON_TAB_SEL_CHANGE(IDC_BOTTOM_TAB, OnTabChange)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_VSFLEXGRID_1, OnBeforeMouseDownTable)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_VSFLEXGRID_2, OnBeforeMouseDownTable)
	ON_CHANGE_LAYER(OnActiveLayerChange)
	
	ON_BN_CLICKED(IDC_BTN_ACTIVATE_REPORT, OnActivateReport)
	ON_BN_CLICKED(IDC_BTN_PREPERENCES, OnPreferences)
	ON_BN_CLICKED(IDC_BTN_EDIT, OnEditData)
	ON_BN_CLICKED(IDC_OUTPUT_RESULT, OnOutputResult)
	ON_EN_CHANGE(IDC_EDIT_REPORT_SHEET, OnResultSheetChange)	
EVENTS_END

	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL	OnDlgResize(int nType, int cx, int cy);
	BOOL	OnRestoreSize(DWORD dwSizeInfo);
	virtual	BOOL	OnDestroy();
	BOOL	OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL	OnOK();
	BOOL	OnCancel();
	
	BOOL	OnTabChange(Control ctrl);
	BOOL	OnBeforeMouseDownTable(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	BOOL	OnActiveLayerChange();
	virtual	BOOL	OnActivateReport(Control ctrl);
	virtual	BOOL	OnPreferences(Control ctrl);
	virtual	BOOL	OnEditData(Control ctrl){ return FALSE; }
	virtual	BOOL	OnOutputResult(Control ctrl){ return FALSE; }
	BOOL	OnResultSheetChange(Control ctrl);

protected:
	BOOL	CheckInitTool();
	virtual	string	GetToolType(){ return "InValidType"; }
	virtual	BOOL	InitButtons();
	virtual	BOOL	ArrangeControls();
	virtual	BOOL	UpdateReportSheetName(LPCSTR lpcszSheetName){ return FALSE; }	///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG
	
protected:
	TabControl	m_BottomTab;
	GridTableControl	m_TableOne;
	GridTableControl	m_TableTwo;
	GraphLayer	m_gl;
	string		m_strMainObjName;
};


///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

///Sophy 6/25/2010 ORG-23-S8 XY_INTERP_FOR_GADGET_TOOL_DLG
//this dialog will reuse the resource for quickfit findxy dialog
enum {
	OUTPUT_TO_SCRIPTWINDOW = 0,
	OUTPUT_TO_RESULTLOG,
	OUTPUT_TO_WORKSHEET,
};
#define	IDC_BTN_INTERP				IDC_BTN_FINDXY
#define	IDC_BTN_OUTPUT				IDC_BTN_FINDXY_OUTPUT
#define	IDC_OUTPUT_TO_SCRIPTWINDOW	IDC_FINDXY_OUTPUT_TO_SCRIPT_WINDOW
#define	IDC_OUTPUT_TO_RESULTLOG		IDC_FINDXY_OUTPUT_TO_RESULT_LOG
#define	IDC_OUTPUT_TO_WORKSHEET		IDC_FINDXY_OUTPUT_TO_WORKSHEET
#define	IDC_OUTPUT_WORKSHEET_NAME	IDC_FINDXY_WORKSHEET
#define	IDC_X_VALUES				IDC_FINDXY_X
#define	IDC_Y_VALUES				IDC_FINDXY_Y
#define	IDC_RANGE_HINTS				IDC_FINDXY_RANGE_HINT

class	InterpXYDlg : public ResizeDialog
{
public:
	InterpXYDlg();
	int DoModalEx(InterpParams& stParams, HWND hWndParent = NULL);
	
protected:
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_READY(OnReady)
	ON_IDLE(OnIdle)
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_OUTPUT_TO_SCRIPTWINDOW, OnOutputChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_RESULTLOG, OnOutputChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_WORKSHEET, OnOutputChange)
	
	ON_BN_CLICKED(IDC_BTN_INTERP, OnClickInterp)
	ON_BN_CLICKED(IDC_BTN_OUTPUT, OnClickOutput);
	ON_BN_CLICKED(IDC_BTN_GO_TO_REPORT, OnClickGoToWorksheet)
	ON_EN_CHANGE(IDC_OUTPUT_WORKSHEET_NAME, OnOutputWorksheetChange)
EVENTS_END
	BOOL	OnInitDialog();
	BOOL	OnReady();
	BOOL	OnIdle();
	BOOL	OnDestroy();
	BOOL	OnOutputChange(Control ctrl);
	BOOL	OnClickInterp(Control ctrl);
	BOOL	OnClickOutput(Control ctrl);
	BOOL	OnClickGoToWorksheet(Control ctrl);
	BOOL	OnOutputWorksheetChange(Control ctrl);

protected:
	void	InitControls();
	void	InitRangeText();
	void	LoadSettings();//registry settings
	void	SaveSettings();
	void	UpdateButtonState();
	int		GetInput(vector& vInput);
	int		GetOutput(const vector& vInput, vector& vOutput);
	int		Calculate(vector& vInput, vector& vOutput);
	
private:
	int		m_nOutputTarget;
	Button	m_btnOutputScriptWindow;
	Button	m_btnOutputResultLog;
	Button	m_btnOutputWorksheet;
	Edit	m_edtWorksheetName;
	Edit	m_edtX;
	Edit	m_edtY;
	InterpParams	m_stParams;
	DataPlot		m_dpSrc;
	bool	m_bFocusReset;
};
///end XY_INTERP_FOR_GADGET_TOOL_DLG
